<?php

$hudson_edge_icon_collections = hudson_edge_return_icon_collections();

$socialPage = new HudsonEdgeAdminPage(
	"12",
	esc_html__( "Social", 'hudson' ),
	"fa fa-share-alt"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"socialPage",
	$socialPage
);

//Enable Social Share

$panel2 = new HudsonEdgePanel(
	esc_html__( "Enable Social Share", 'hudson' ),
	"social_sharing_panel"
);
$socialPage->addChild(
	"panel2",
	$panel2
);

$enable_social_share = new HudsonEdgeField(
	"yesno",
	"enable_social_share",
	"yes",
	esc_html__( "Enable Social Share", 'hudson' ),
	esc_html__( "Enabling this option will allow social share on networks of your choice", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_social_networks_panel,#edgtf_show_social_share_panel"
	)
);
$panel2->addChild(
	"enable_social_share",
	$enable_social_share
);

//Show Social Share

$panel3 = new HudsonEdgePanel(
	esc_html__( "Show Social Share On", 'hudson' ),
	"show_social_share_panel",
	"enable_social_share",
	"no"
);
$socialPage->addChild(
	"panel3",
	$panel3
);

$post_types_names_post = new HudsonEdgeField(
	"flagpost",
	"post_types_names_post",
	"post",
	esc_html__( "Posts", 'hudson' ),
	esc_html__( "Show Social Share on Blog Posts", 'hudson' )
);
$panel3->addChild(
	"post_types_names_post",
	$post_types_names_post
);

$post_types_names_page = new HudsonEdgeField(
	"flagpage",
	"post_types_names_page",
	"",
	esc_html__( "Pages", 'hudson' ),
	esc_html__( "Show Social Share on Pages", 'hudson' )
);
$panel3->addChild(
	"post_types_names_page",
	$post_types_names_page
);

$post_types_names_attachment = new HudsonEdgeField(
	"flagmedia",
	"post_types_names_attachment",
	"",
	esc_html__( "Media", 'hudson' ),
	esc_html__( "Show Social Share for Images and Videos", 'hudson' )
);
$panel3->addChild(
	"post_types_names_attachment",
	$post_types_names_attachment
);

$post_types_names_portfolio_page = new HudsonEdgeField(
	"flagportfolio",
	"post_types_names_portfolio_page",
	"",
	esc_html__( "Portfolio Item", 'hudson' ),
	esc_html__( "Show Social Share for Portfolio Items", 'hudson' )
);
$panel3->addChild(
	"post_types_names_portfolio_page",
	$post_types_names_portfolio_page
);

if ( hudson_edge_is_woocommerce_installed() ) {
	$post_types_names_product = new HudsonEdgeField(
		"flagproduct",
		"post_types_names_product",
		"",
		esc_html__( "Product", 'hudson' ),
		esc_html__( "Show Social Share for Product Items", 'hudson' )
	);
	$panel3->addChild(
		"post_types_names_product",
		$post_types_names_product
	);
}

//Social Share Networks

$panel4 = new HudsonEdgePanel(
	esc_html__( "Social Networks", 'hudson' ),
	"social_networks_panel",
	"enable_social_share",
	"no"
);
$socialPage->addChild(
	"panel4",
	$panel4
);

//Facebook

$facebook_subtitle = new HudsonEdgeTitle(
	"facebook_subtitle",
	esc_html__( "Share on Facebook", 'hudson' )
);
$panel4->addChild(
	"facebook_subtitle",
	$facebook_subtitle
);

$enable_facebook_share = new HudsonEdgeField(
	"yesno",
	"enable_facebook_share",
	"yes",
	esc_html__( "Enable Share", 'hudson' ),
	esc_html__( "Enabling this option will allow sharing via Facebook", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_facebook_share_container"
	)
);
$panel4->addChild(
	"enable_facebook_share",
	$enable_facebook_share
);

$enable_facebook_share_container = new HudsonEdgeContainer(
	"enable_facebook_share_container",
	"enable_facebook_share",
	"no"
);
$panel4->addChild(
	"enable_facebook_share_container",
	$enable_facebook_share_container
);

$facebook_icon = new HudsonEdgeField(
	"image",
	"facebook_icon",
	"",
	esc_html__( "Upload Icon", 'hudson' ),
	""
);
$enable_facebook_share_container->addChild(
	"facebook_icon",
	$facebook_icon
);

//Twitter
$twitter_subtitle = new HudsonEdgeTitle(
	"twitter_subtitle",
	esc_html__( "Share on Twitter", 'hudson' )
);
$panel4->addChild(
	"twitter_subtitle",
	$twitter_subtitle
);

$enable_twitter_share = new HudsonEdgeField(
	"yesno",
	"enable_twitter_share",
	"yes",
	esc_html__( "Enable Share", 'hudson' ),
	esc_html__( "Enabling this option will allow sharing via Twitter", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_twitter_share_container"
	)
);
$panel4->addChild(
	"enable_twitter_share",
	$enable_twitter_share
);
$enable_twitter_share_container = new HudsonEdgeContainer(
	"enable_twitter_share_container",
	"enable_twitter_share",
	"no"
);
$panel4->addChild(
	"enable_twitter_share_container",
	$enable_twitter_share_container
);
$twitter_icon = new HudsonEdgeField(
	"image",
	"twitter_icon",
	"",
	esc_html__( "Upload Icon", 'hudson' ),
	""
);
$enable_twitter_share_container->addChild(
	"twitter_icon",
	$twitter_icon
);
$twitter_via = new HudsonEdgeField(
	"text",
	"twitter_via",
	"",
	esc_html__( "Via", 'hudson' ),
	""
);
$enable_twitter_share_container->addChild(
	"twitter_via",
	$twitter_via
);

//Google Plus

$google_plus_subtitle = new HudsonEdgeTitle(
	"google_plus_subtitle",
	esc_html__( "Share on Google Plus", 'hudson' )
);
$panel4->addChild(
	"google_plus_subtitle",
	$google_plus_subtitle
);

$enable_google_plus = new HudsonEdgeField(
	"yesno",
	"enable_google_plus",
	"no",
	esc_html__( "Enable Share", 'hudson' ),
	esc_html__( "Enabling this option will allow sharing via Google Plus", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_google_plus_container"
	)
);
$panel4->addChild(
	"enable_google_plus",
	$enable_google_plus
);
$enable_google_plus_container = new HudsonEdgeContainer(
	"enable_google_plus_container",
	"enable_google_plus",
	"no"
);
$panel4->addChild(
	"enable_google_plus_container",
	$enable_google_plus_container
);
$google_plus_icon = new HudsonEdgeField(
	"image",
	"google_plus_icon",
	"",
	esc_html__( "Upload Icon", 'hudson' ),
	""
);
$enable_google_plus_container->addChild(
	"google_plus_icon",
	$google_plus_icon
);

//LinkedIn

$linkedin_subtitle = new HudsonEdgeTitle(
	"linkedin_subtitle",
	esc_html__( "Share on LinkedIn", 'hudson' )
);
$panel4->addChild(
	"linkedin_subtitle",
	$linkedin_subtitle
);

$enable_linkedin = new HudsonEdgeField(
	"yesno",
	"enable_linkedin",
	"no",
	esc_html__( "Enable Share", 'hudson' ),
	esc_html__( "Enabling this option will allow sharing via LinkedIn", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_linkedin_container"
	)
);
$panel4->addChild(
	"enable_linkedin",
	$enable_linkedin
);
$enable_linkedin_container = new HudsonEdgeContainer(
	"enable_linkedin_container",
	"enable_linkedin",
	"no"
);
$panel4->addChild(
	"enable_linkedin_container",
	$enable_linkedin_container
);
$linkedin_icon = new HudsonEdgeField(
	"image",
	"linkedin_icon",
	"",
	esc_html__( "Upload Icon", 'hudson' ),
	""
);
$enable_linkedin_container->addChild(
	"linkedin_icon",
	$linkedin_icon
);

//Tumblr

$tumblr_subtitle = new HudsonEdgeTitle(
	"tumblr_subtitle",
	esc_html__( "Share on Tumblr", 'hudson' )
);
$panel4->addChild(
	"tumblr_subtitle",
	$tumblr_subtitle
);

$enable_tumblr = new HudsonEdgeField(
	"yesno",
	"enable_tumblr",
	"yes",
	esc_html__( "Enable Share", 'hudson' ),
	esc_html__( "Enabling this option will allow sharing via Tumblr", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_tumblr_container"
	)
);
$panel4->addChild(
	"enable_tumblr",
	$enable_tumblr
);

$enable_tumblr_container = new HudsonEdgeContainer(
	"enable_tumblr_container",
	"enable_tumblr",
	"no"
);
$panel4->addChild(
	"enable_tumblr_container",
	$enable_tumblr_container
);

$tumblr_icon = new HudsonEdgeField(
	"image",
	"tumblr_icon",
	"",
	esc_html__( "Upload Icon", 'hudson' ),
	""
);
$enable_tumblr_container->addChild(
	"tumblr_icon",
	$tumblr_icon
);

// Pinterest

$pinterest_subtitle = new HudsonEdgeTitle(
	"pinterest_subtitle",
	esc_html__( "Share on Pinterest", 'hudson' )
);
$panel4->addChild(
	"pinterest_subtitle",
	$pinterest_subtitle
);

$enable_pinterest = new HudsonEdgeField(
	"yesno",
	"enable_pinterest",
	"yes",
	esc_html__( "Enable Share", 'hudson' ),
	esc_html__( "Enabling this option will allow sharing via Pinterest", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_pinterest_container"
	)
);
$panel4->addChild(
	"enable_pinterest",
	$enable_pinterest
);
$enable_pinterest_container = new HudsonEdgeContainer(
	"enable_pinterest_container",
	"enable_pinterest",
	"no"
);
$panel4->addChild(
	"enable_pinterest_container",
	$enable_pinterest_container
);
$pinterest_icon = new HudsonEdgeField(
	"image",
	"pinterest_icon",
	"",
	esc_html__( "Upload Icon", 'hudson' ),
	""
);
$enable_pinterest_container->addChild(
	"pinterest_icon",
	$pinterest_icon
);

//VK

$vk_subtitle = new HudsonEdgeTitle(
	"vk_subtitle",
	esc_html__( "Share on VK", 'hudson' )
);
$panel4->addChild(
	"vk_subtitle",
	$vk_subtitle
);

$enable_vk = new HudsonEdgeField(
	"yesno",
	"enable_vk",
	"no",
	esc_html__( "Enable Share", 'hudson' ),
	esc_html__( "Enabling this option will allow sharing via VK", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_vk_container"
	)
);
$panel4->addChild(
	"enable_vk",
	$enable_vk
);
$enable_vk_container = new HudsonEdgeContainer(
	"enable_vk_container",
	"enable_vk",
	"no"
);
$panel4->addChild(
	"enable_vk_container",
	$enable_vk_container
);
$vk_icon = new HudsonEdgeField(
	"image",
	"vk_icon",
	"",
	esc_html__( "Upload Icon", 'hudson' ),
	""
);
$enable_vk_container->addChild(
	"vk_icon",
	$vk_icon
);

if ( defined( 'HUDSON_INSTAGRAM_FEED_VERSION' ) ) {

	$instagram_panel = new HudsonEdgePanel(
		esc_html__( 'Instagram', 'hudson' ),
		'instagram_panel'
	);

	$socialPage->addChild(
		"instagram_panel",
		$instagram_panel
	);

	$instagram_field = new HudsonEdgeInstagramFramework();
	$instagram_panel->addChild(
		'instagram_field',
		$instagram_field
	);
}